<?php

defined('BASEPATH') or exit('No direct script access allowed');

$dimensions = $pdf->getPageDimensions();

$info_right_column = '';
$info_left_column  = '';
$invoice_info1 = '';
$img="";
$pdf_footer="";
//$info_right_column .= '<span style="font-weight:bold;font-size:27px;">' . _l('invoice_pdf_heading') . '</span><br />';
$info_right_column .= '<b style="color:#4e4e4e; font-size:25px"># ' . $invoice_number . '</b>';

if (get_option('show_status_on_pdf_ei') == 1) {
    $info_right_column .= '<br /><span style="font-size:25px; color:rgb(' . invoice_status_color_pdf($status) . ');text-transform:uppercase;">' . format_invoice_status($status, '', false) . '</span>';
}

if ($status != Invoices_model::STATUS_PAID && $status != Invoices_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
    && found_invoice_mode($payment_modes, $invoice->id, false)) {
    $info_right_column .= ' - <a style="color:#84c529;text-decoration:none;text-transform:uppercase; font-size:25px" href="' . site_url('invoice/' . $invoice->id . '/' . $invoice->hash) . '"><1b>' . _l('view_invoice_pdf_link_pay') . '</1b></a>';
}

// Add logo
// $info_left_column .= pdf_logo_url();

// $img.='<img  src="https://sky.jellysoftindia.com/assets/images/header2.png" width="890"  height="100" >';
$img.='<img  src="' . base_url('assets/images/header2.png') . '" width="890"  height="100" >';

 //$pdf->writeHTML($img, true, false, false, false, '');
 $pdf->writeHTML($img, true, false, true, false, '');
// $pdf->writeHTML($img, true, false, false, false, '');
$invoice_info1 .= '<br /><b>' . _l('invoice_data_date') . '</b> ' . _d($invoice->date) . '<br />';

if (!empty($invoice->duedate)) {
    $invoice_info1 .= '<b>'._l('invoice_data_duedate') . '</b> ' . _d($invoice->duedate) . '<br />';
}

if ($invoice->sale_agent != 0 && get_option('show_sale_agent_on_invoices') == 1) {
    $invoice_info1 .= '<b>'._l('sale_agent_string') . ': </b>' . get_staff_full_name($invoice->sale_agent) . '<br />';
}

if ($invoice->project_id != 0 && get_option('show_project_on_invoice') == 1) {
    $invoice_info1 .= '<b>'._l('project') . ':  </b>' . get_project_name_by_id($invoice->project_id) . '<br />';
}
// Write top left logo and right column info/text
pdf_multi_row($invoice_info1, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

$pdf->ln(1);
$organization_info = '<b>'. "From". ':</b>';

$organization_info .= '<div style="color:#424242;">';

$organization_info .= format_organization_info();

$organization_info .= '</div>';

// Bill to
$invoice_info = '<b>' . _l('invoice_bill_to') . ':</b>';
$invoice_info .= '<div style="color:#424242;">';
    $invoice_info .= format_customer_info($invoice, 'invoice', 'billing');
$invoice_info .= '</div>';

// ship to to
if ($invoice->include_shipping == 1 && $invoice->show_shipping_on_invoice == 1) {
    // $invoice_info .= '<br /><b>' . _l('ship_to') . ':</b>';
    // $invoice_info .= '<div style="color:#424242;">';
    // $invoice_info .= format_customer_info($invoice, 'invoice', 'shipping');
    // $invoice_info .= '</div>';
}





foreach ($pdf_custom_fields as $field) {
    $value = get_custom_field_value($invoice->id, $field['id'], 'invoice');
    if ($value == '') {
        continue;
    }
    $invoice_info .= $field['name'] . ': ' . $value . '<br />';
}

$left_info  = $swap == '1' ? $invoice_info : $organization_info;
$right_info = $swap == '1' ? $organization_info : $invoice_info;

pdf_multi_row($left_info, $right_info, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

// The Table
$pdf->Ln(hooks()->apply_filters('pdf_info_and_table_separator', 6));

// The items table
$items = get_items_table_data($invoice, 'invoice', 'pdf');

$tblhtml = $items->table();

$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(2);

$tbltotal = '';
$tbltotal .= '<table cellpadding="6" style="font-size:' . ($font_size + 4) . 'px">';
$tbltotal .= '
<tr>
    <td align="right" width="85%"><strong>' . _l('invoice_subtotal') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->subtotal, $invoice->currency_name) . '</td>
</tr>';

if (is_sale_discount_applied($invoice)) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('invoice_discount');
    if (is_sale_discount($invoice, 'percent')) {
        $tbltotal .= ' (' . app_format_number($invoice->discount_percent, true) . '%)';
    }
    $tbltotal .= '</strong>';
    $tbltotal .= '</td>';
    $tbltotal .= '<td align="right" width="15%">-' . app_format_money($invoice->discount_total, $invoice->currency_name) . '</td>
    </tr>';
}

foreach ($items->taxes() as $tax) {
    $tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)' . '</strong></td>
    <td align="right" width="15%">' . app_format_money($tax['total_tax'], $invoice->currency_name) . '</td>
</tr>';
}

if ((int) $invoice->adjustment != 0) {
    $tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . _l('invoice_adjustment') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->adjustment, $invoice->currency_name) . '</td>
</tr>';
}

$tbltotal .= '
<tr style="background-color:#f0f0f0;">
    <td align="right" width="85%"><strong>' . _l('invoice_total') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->total, $invoice->currency_name) . '</td>
</tr>';

if (count($invoice->payments) > 0 && get_option('show_total_paid_on_invoice') == 1) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('invoice_total_paid') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money(sum_from_table(db_prefix().'invoicepaymentrecords', [
        'field' => 'amount',
        'where' => [
            'invoiceid' => $invoice->id,
        ],
    ]), $invoice->currency_name) . '</td>
    </tr>';
}

if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('applied_credits') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money($credits_applied, $invoice->currency_name) . '</td>
    </tr>';
}

if (get_option('show_amount_due_on_invoice') == 1 && $invoice->status != Invoices_model::STATUS_CANCELLED) {
    $tbltotal .= '<tr style="background-color:#f0f0f0;">
       <td align="right" width="85%"><strong>' . _l('invoice_amount_due') . '</strong></td>
       <td align="right" width="15%">' . app_format_money($invoice->total_left_to_pay, $invoice->currency_name) . '</td>
   </tr>';
}

$tbltotal .= '</table>';
$pdf->writeHTML($tbltotal, true, false, false, false, '');

if (get_option('total_to_words_enabled') == 1) {
    // Set the font bold
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->writeHTMLCell('', '', '', '', _l('num_word') . ': ' . $CI->numberword->convert($invoice->total, $invoice->currency_name).' Only', 0, 1, false, true, 'C', true);
    // Set the font again to normal like the rest of the pdf
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
}

if (count($invoice->payments) > 0 && get_option('show_transactions_on_invoice_pdf') == 1) {
    $pdf->Ln(2);
    $border = 'border-bottom-color:#000000;border-bottom-width:1px;border-bottom-style:solid; 1px solid black;';
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_received_payments') . ":", 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
        <tr height="20"  style="color:#000;border:1px solid #000;">
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_number_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_mode_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_date_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_amount_heading') . '</th>
    </tr>';
    $tblhtml .= '<tbody>';
    foreach ($invoice->payments as $payment) {
        $payment_name = $payment['name'];
        if (!empty($payment['paymentmethod'])) {
            $payment_name .= ' - ' . $payment['paymentmethod'];
        }
        $tblhtml .= '
            <tr>
            <td>' . $payment['paymentid'] . '</td>
            <td>' . $payment_name . '</td>
            <td>' . _d($payment['date']) . '</td>
            <td>' . app_format_money($payment['amount'], $invoice->currency_name) . '</td>
            </tr>
        ';
    }
    $tblhtml .= '</tbody>';
    $tblhtml .= '</table>';
    $pdf->writeHTML($tblhtml, true, false, false, false, '');
}

if (found_invoice_mode($payment_modes, $invoice->id, true, true)) {
    $pdf->Ln(2);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_html_offline_payment') . ":", 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);

    foreach ($payment_modes as $mode) {
        if (is_numeric($mode['id'])) {
            if (!is_payment_mode_allowed_for_invoice($mode['id'], $invoice->id)) {
                continue;
            }
        }
        if (isset($mode['show_on_pdf']) && $mode['show_on_pdf'] == 1) {
            $pdf->Ln(1);
            $pdf->Cell(0, 0, $mode['name'], 0, 1, 'L', 0, '', 0);
            $pdf->Ln(2);
            $pdf->writeHTMLCell('', '', '', '', $mode['description'], 0, 1, false, true, 'L', true);
        }
    }
}



$pdf->Ln(1);
// Left column (Bank details)
$pdf->SetX($pdf->GetX() + 20);
$pdf->SetFont($font_name, 'UB', $font_size);
// $pdf->SetFont($font_name, 'B', $font_size);
$pdf->Cell(0, 0, "Bank Details", 0, 1, 'L', 0, '', 0);
$pdf->SetFont($font_name, '', $font_size);

// $pdf->SetX($pdf->GetX() + 20);
// $pdf->SetFont($font_name, 'B', $font_size);
// $pdf->Cell(0, 0, "------- -----------", 0, 1, 'L', 0, '', 0);
// $pdf->SetFont($font_name, '', $font_size);


// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "Bank Name: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "IDBI BANK" . '</strong></td>

//     <td align="right" width="25%"><strong>' . "Gpay: " . '</strong></td>
//     <td align="right" width="15%"><strong>' . "7092150100" . '</strong></td>
// </tr>';





// $tbltotal = '';
// $tbltotal .= '<table cellpadding="6" style="font-size:' . ($font_size + 4) . 'px;line-height: 0.428571;">';

// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "Bank Name: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "IDBI BANK" . '</strong></td>
// </tr>';


// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "Account Number: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "0371102000019345" . '</strong></td>
// </tr>';

// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "Account Name: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "JELLYSOFT" . '</strong></td>
// </tr>';

// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "IFSC Code: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "IBKL0000371" . '</strong></td>
// </tr>';
// $tbltotal .= '
// <tr>
//     <td align="left" width="20%">  
//         <img src="' . base_url('assets/images/gpay.png') . '" alt="Gpay" width="20" height="20">
//         <img src="' . base_url('assets/images/phonepe.png') . '" alt="PhonePe" width="20" height="20">
//         <img src="' . base_url('assets/images/paytm.png') . '" alt="Paytm" width="20" height="20">
//     </td>    
//     <td style="padding-bottom:30px;" align="left" width="20%"><strong>7092150100</strong></td>

 
// </tr>';

// $tbltotal .= '
// <tr>
//     <td align="left" width="20%"><strong>' . "UPI Id: " . '</strong></td>
//     <td align="left" width="25%"><strong>' . "jellysoft@okaxis" . '</strong></td>

// </tr>';



// $tbltotal .= '
// <tr style="margin-bottom:20px !important;padding-bottom:20px !important;">
// <td align="left" width="20%"><strong>' . " " . '</strong></td>
//     <td align="left" width="25%"><strong>' . " " . '</strong></td>
//     <td align="right" width="44%" style="margin-bottom:20px !important;padding-bottom:20px !important;">
//         <img src="' . base_url('uploads/company/sign.jpg') . '" alt="Gpay" width="70" height="70">
//     </td>
// </tr>';

// $tbltotal .= '
// <tr>
// <td align="left" width="20%"><strong>' . " " . '</strong></td>
//     <td align="left" width="25%"><strong>' . " " . '</strong></td>
//     <td align="right" width="48%" style="font-size:' . ($font_size + 6) . 'px;">
//     &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Authorized Signature
//     </td>
// </tr>';

// $tbltotal .= '</table>';
// $pdf->writeHTML($tbltotal, true, false, false, false, '');


if($invoice->show_seal_on_pdf){
    $seal = '<img style="margin-right:10%;" src="' . base_url('uploads/company/seal.png') . '" alt="Gpay" height="100" width="100">';
} else {
    $seal = '';
}
if($invoice->show_sign_on_pdf){
    $sign = '<img style="width:50px !important;" src="' . base_url('uploads/company/sign.jpg') . '" alt="Gpay" height="40" >';
    $sign_space = '';
} else {
    $sign = '';
    $sign_space = '<br><br>';
}


$tbltotals .= '<table cellpadding="6" style="font-size:' . ($font_size + 4) . 'px;line-height: 1.428571;">';
$tbltotals .= '
<tr>
    <td align="left" width="50%">
        <strong>' . "Bank Name: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IDBI BANK" . '</strong><br>

        <strong>' . "Account Number: &nbsp;&nbsp;&nbsp;&nbsp;0371102000019345" . '</strong><br>

        <strong>' . "Account Name: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;JELLYSOFT" . '</strong><br>

        <strong>' . "IFSC Code: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IBKL0000371" . '</strong><br>

        <strong>' . "UPI Id: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;jellysoft@okaxis" . '</strong><br>

        <img src="' . base_url('assets/images/gpay.png') . '" alt="Gpay" width="25" height="20">
        <img src="' . base_url('assets/images/phonepe.png') . '" alt="PhonePe" width="20" height="20">
        <img src="' . base_url('assets/images/paytm.png') . '" alt="Paytm" width="20" height="20">
        <strong>' . "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7092150100" . '</strong><br>
    </td>
    
    <td align="right" width="20%" style="font-size:' . ($font_size + 6) . 'px;">
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        '. $seal .'
       
    </td>
    
    <td align="right" width="30%" style="font-size:' . ($font_size + 6) . 'px;">
        ' . $sign . '
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>' . $sign_space . '
        <strong>' . "Authorized Signature" . '</strong>
    </td>
</tr>';
// <img style="width:50px !important;" src="' . base_url('uploads/company/sign.jpg') . '" alt="Gpay" height="40" > remove two br also
$tbltotals .= '</table>';
$pdf->writeHTML($tbltotals, true, false, false, false, '');


if (!empty($invoice->clientnote)) {
    // $pdf->Ln(2);
    // $pdf->SetFont($font_name, 'B', $font_size);
    // $pdf->Cell(0, 0, _l('invoice_note'), 0, 1, 'L', 0, '', 0);
    // $pdf->SetFont($font_name, '', $font_size);
    // $pdf->Ln(2);
    // $pdf->writeHTMLCell('', '', '', '', $invoice->clientnote, 0, 1, false, true, 'L', true);
}

if (!empty($invoice->terms)) {
    $pdf->Ln(2);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_note') . ":", 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $invoice->terms, 0, 1, false, true, 'L', true);
}
// $pdf_footer.='<img  src="https://sky.jellysoftindia.com/assets/images/footer.jpg" width="890"  height="100" >';
$pdf_footer = '<img src="' . base_url('assets/images/footer.jpg') . '" width="890" height="100">';

// $pdf->writeHTML($pdf_footer, true, false, false, false, '');
// $pdf->footer($pdf_footer);