<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account\Call;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class PaymentList extends ListResource {
    /**
     * Construct the PaymentList
     *
     * @param Version $version Version that contains the resource
     * @param string $accountSid The SID of the Account that created the Payments
     *                           resource.
     * @param string $callSid The SID of the Call the resource is associated with.
     * @return \Twilio\Rest\Api\V2010\Account\Call\PaymentList
     */
    public function __construct(Version $version, $accountSid, $callSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('accountSid' => $accountSid, 'callSid' => $callSid, );

        $this->uri = '/Accounts/' . \rawurlencode($accountSid) . '/Calls/' . \rawurlencode($callSid) . '/Payments.json';
    }

    /**
     * Create a new PaymentInstance
     *
     * @param string $idempotencyKey A unique token for each payment session that
     *                               should be provided to maintain idempotency of
     *                               the session.
     * @param string $statusCallback The URL we should call to send status of
     *                               payment session.
     * @param array|Options $options Optional Arguments
     * @return PaymentInstance Newly created PaymentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create($idempotencyKey, $statusCallback, $options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'IdempotencyKey' => $idempotencyKey,
            'StatusCallback' => $statusCallback,
            'BankAccountType' => $options['bankAccountType'],
            'ChargeAmount' => $options['chargeAmount'],
            'Currency' => $options['currency'],
            'Description' => $options['description'],
            'Input' => $options['input'],
            'MinPostalCodeLength' => $options['minPostalCodeLength'],
            'Parameter' => Serialize::jsonObject($options['parameter']),
            'PaymentConnector' => $options['paymentConnector'],
            'PaymentMethod' => $options['paymentMethod'],
            'PostalCode' => Serialize::booleanToString($options['postalCode']),
            'SecurityCode' => Serialize::booleanToString($options['securityCode']),
            'Timeout' => $options['timeout'],
            'TokenType' => $options['tokenType'],
            'ValidCardTypes' => $options['validCardTypes'],
        ));

        $payload = $this->version->create(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new PaymentInstance(
            $this->version,
            $payload,
            $this->solution['accountSid'],
            $this->solution['callSid']
        );
    }

    /**
     * Constructs a PaymentContext
     *
     * @param string $sid The SID of Payments session
     * @return \Twilio\Rest\Api\V2010\Account\Call\PaymentContext
     */
    public function getContext($sid) {
        return new PaymentContext(
            $this->version,
            $this->solution['accountSid'],
            $this->solution['callSid'],
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Api.V2010.PaymentList]';
    }
}